//console.log("smartup started.");
Array.prototype.contains=function (ele) {
    for (var i=0;i<this.length;i++){
        if (this[i]==ele){
            return true;
        }
	}
	return false;
}
var editMode,editDirect;
var _OS="win";
var config={};

var sue={
	cons:{
		fix_linux_value:false,
		fix_linux_timer:null,
		os:"win"
	},
	apps:{
		enable:false,
	},
	init:function(){
		sue.initHandle();
		sue.uistyle={};
		sue.uistyle.mges=[];
		var _uimges=["direct","tip","note"];
		for(var i=0;i<_uimges.length;i++){
			if(config.mges.ui[_uimges[i]].enable){
				sue.uistyle.mges.push(config.mges.ui[_uimges[i]].style);
			}else{
				sue.uistyle.mges.push("none");
			}
		}
	},
	initHandle:function(){
		if(config.general.fnswitch.fnmges){
			document.addEventListener("mousedown",this,false);
			document.addEventListener("mouseup",this,false);
			document.addEventListener("mousemove",this,false);
			document.addEventListener("mouseover",this,false);
			document.addEventListener("contextmenu", this, false);
		}
		if(config.general.fnswitch.fndrg||config.general.fnswitch.fnsdrg){
			window.addEventListener("dragstart", this, false);
			window.addEventListener("drag", this, false);
			window.addEventListener("dragover", this, false);
			window.addEventListener("dragend", this, false);
		}
		if(config.general.settings.esc){
			window.addEventListener("keydown",this,false);
		}
	},
	initHandle2:function(){
		//document.addEventListener("mousedown",this,false);
		sue.document.addEventListener("mouseup",this,false);
		sue.document.addEventListener("mousemove",this,false);
		sue.document.addEventListener("mouseover",this,false);
		sue.document.addEventListener("contextmenu", this, false);
	},
	handleEvent:function(e){
		switch(e.type){
			case"keydown":
				if(e.keyCode==27){
					sue.break=true;
					sue.stopMges(e);
					sue.timeout_nomenu=true;
				}
				break;
			case"mousedown":
				if(e.button==config.mges.settings.model
					&&!e[config.mges.settings.holdkey+"Key"]){
					sue.lineDrawReady(e,"mges");
				}
				break;
			case"mouseup":
				if((e.button==1&&e.button==config.mges.settings.model)
					||(e.button==2&&e.button==config.mges.settings.model&&_OS!="win")){
					if(sue._dirArray&&sue.drawing){
						sue.stopMges(e);
					}
					sue.clearUI();
					sue.drawing=false;
					sue._lastX=e.clientX;
					sue._lastY=e.clientY;
				}
				break;
			case"contextmenu":
				if(config.general.linux.cancelmenu
					&&_OS!="win"){
						if(!sue.cons.fix_linux_value&&config.mges.settings.model==2){
							e.preventDefault();
						}
						sue.cons.fix_linux_value=true;
						window.clearTimeout(sue.cons.fix_linux_timer);
						sue.cons.fix_linux_timer=window.setTimeout(function(){sue.cons.fix_linux_value=false;},500)
						break;
				}
				if(sue._dirArray&&sue.drawing){
					sue.stopMges(e);
				}
				if(sue.drawing&&config.mges.settings.model==2){
					//e.preventDefault();
					sue.clearUI();
					sue.drawing=false;
					sue._lastX=e.clientX;
					sue._lastY=e.clientY;					
				}
				if(config.general.settings.timeout_nomenu&&sue.timeout_nomenu){
					sue.timeout_nomenu=false;
					e.preventDefault();
				}
				break;
			case"mousemove":
				if(sue.drawing&&e.button==config.mges.settings.model){
					sue.lineDraw(e);
				}
				break;
			case"dragstart":
				if((config.general.fnswitch.fndrg&&!e[config.drg.settings.holdkey+"Key"])
					||(config.general.fnswitch.fnsdrg&&!e[config.sdrg.settings.holdkey+"Key"])){
					sue.lineDrawReady(e,config.general.fnswitch.fndrg?"drg":"sdrg");
				}
				break;
			case"dragover":
				if(sue.drawing){
					sue.lineDraw(e,sue.drawType[0]);
					if(sue.drawType[0]=="drg"&&config[sue.drawType[0]].ui.tip.type=="follow"){
						sue.uiPos(e);
					}
					if(config[sue.drawType[0]].settings.drgcursor){
						e.dataTransfer.effectAllowed="move"
						e.dataTransfer.dropEffect="move";
						e.preventDefault();						
					}
				}
				break;
			case"dragend":
				//console.log("dragend")
				if(sue._dirArray&&sue.drawing){
					sue.stopMges(e);
				}
				sue.drawing=false;
				sue._lastX=e.clientX;
				sue._lastY=e.clientY;
				break;
		}
	},
	regURL:function(txt){
		var reg=/^((http|https|ftp):\/\/)?(\w(\:\w)?@)?([0-9a-z_-]+\.)*?([a-z0-9-]+\.[a-z]{2,6}(\.[a-z]{2})?(\:[0-9]{2,6})?)((\/[^?#<>\/\\*":]*)+(\?[^#]*)?(#.*)?)?$/i; 
		return reg.test(txt);
	},
	lineDrawReady:function(e,type){
		//console.log("lineDrawReady");
        sue._lastX=e.clientX;
        sue._lastY=e.clientY;
        sue._startX=e.clientX;
        sue._startY=e.clientY;
        sue._dirArray="";
        sue.drawing=true;

        if(type=="drg"||type=="sdrg"){
        	switch(e.target.nodeType){
        		case 3:
        			//sue.drawType=["drg","tdrg"]
        			sue.drawType=[type,"t"+type]
        			break;
        		case 1:
        			if(e.target.src){
        				sue.drawType=[type,"i"+type]//["drg","idrg"];
        			}else if(e.target.href){
        				sue.drawType=[type,"l"+type]//["drg","ldrg"];
        			}else{
        				sue.drawType=[type,"t"+type]//["drg","tdrg"];
        			}
        			break;
        	}
			//enable drag in text box
			if(!config[type].settings.drgbox){
				if(e.button==0&&e.target.tagName&&((e.target.tagName.toLowerCase()=="input"&&e.target.type=="text")||e.target.tagName.toLowerCase()=="textarea")){
					//console.log("fff")
					sue.drawing=false;
				}
			}
        }else if(type=="mges"){
        	sue.drawType=["mges","mges"];
        }

        sue.selEle={};
        sue.selEle.txt=window.getSelection().toString();
        sue.selEle.lnk=e.href||e.target.href;
        sue.selEle.img=e.target.src;
        sue.selEle.str=e.target.innerText;
        sue.startEle=e.target;

        //txt to url for mges
        if(type=="mges"&&config.mges.settings.txttourl&&sue.regURL(sue.selEle.txt)){
        	sue.selEle.lnk=sue.selEle.txt;
        }

        //txt to url for drag
        if(type!="mges"&&((config.general.fnswitch.fnsdrg&&config.sdrg.settings.drgurl)||(config.general.fnswitch.fndrg&&config.drg.settings.drgurl))){
			if(sue.regURL(sue.selEle.txt)){
				sue.drawType=[type,"l"+type];
				sue.selEle.lnk=sue.selEle.txt;
			}
        }

		var ele=e.target;
		var getParent=function(win){
			if(win.parent&&win.parent!=win){
				return arguments.callee(win.parent);
			}else{
				return win
			}
		}
		t=getParent(window);
		sue.window=t;
		sue.document=t.document.documentElement;
		sue.initHandle2();

		//drag fn switch
		if(sue.drawType[1]==("t"+type)&&!config[type].settings.txt){
			sue.drawing=false;
		}
		if(sue.drawType[1]==("l"+type)&&!config[type].settings.lnk){
			sue.drawing=false;
		}
		if(sue.drawType[1]==("i"+type)&&!config[type].settings.img){
			sue.drawing=false;
		}

		//sue.clearUI();
		var _uiarray=["direct","tip","note","allaction"];
		var _uiset=[];
		for(var i=0;i<_uiarray.length;i++){
			if(config[sue.drawType[0]].ui&&config[sue.drawType[0]].ui[_uiarray[i]].enable){
				sue.UI(config[sue.drawType[0]].ui[_uiarray[i]].style);
			}
		}

		return
	},
	lineDraw:function(e,type){
		sue.uiPos(e)
        var x=e.clientX;
        var y=e.clientY;
        var dx=Math.abs(x-sue._lastX);
        var dy=Math.abs(y-sue._lastY);
        var dz=Math.sqrt(Math.pow(dx, 2) + Math.pow(dy, 2));

		if(dz<1){return}
        sue.drawType[0]!="sdrg"&&config[sue.drawType[0]].ui.line.enable?sue.ui_line(e):null;
		if(dx<config.general.settings.minlength
			&&dy<config.general.settings.minlength){
			return;
		}

	    var dir;
        if(sue.drawType[0]=="sdrg"){
	        var angle=180/(Math.PI/Math.acos(dy/dz));

	        if(angle<=15&&dx<dy&&y<sue._lastY){
	        	dir="U"
	        }else if(angle<=15&&dx<dy&&y>sue._lastY){
	        	dir="D"
	        }else if(angle>75&&angle<=90&&dx>dy&&x>sue._lastX){
	        	dir="R"
	        }else if(angle>75&&angle<=90&&dx>dy&&x<sue._lastX){
	        	dir="L"
	        }else if(angle>15&&angle<=75&&y<sue._lastY&&x<sue._lastX){
	        	dir="l"
	        }else if(angle>15&&angle<=75&&y<sue._lastY&&x>sue._lastX){
	        	dir="u"
	        }else if(angle>15&&angle<=75&&y>sue._lastY&&x>sue._lastX){
	        	dir="r"
	        }else if(angle>15&&angle<=75&&y>sue._lastY&&x<sue._lastX){
	        	dir="d"
	        }
        }else{
	        if(dx>dy ){
	            dir=x<sue._lastX?"L":"R";
			}else{
	            dir=y<sue._lastY?"U":"D";
	        }        	
        }

        var lastDir=sue._dirArray.substr(sue._dirArray.length-1,1);
        if(dir!=lastDir){
        	sue._dirArray+=dir;
        	//show direct
        	sue.drawType[0]!="sdrg"&&config[sue.drawType[0]].ui.direct.enable?sue.ui_direct(e):null;
        	//get tip
        	sue.drawType[0]!="sdrg"&&(config[sue.drawType[0]].ui.tip.enable||config[sue.drawType[0]].ui.note.enable)?sue.sendDir(sue._dirArray,"gettip",e):null;
        }
		//timeout
		if(config.general.settings.timeout){
			if(sue.timeout){window.clearTimeout(sue.timeout);sue.break=false;}
			sue.timeout=window.setTimeout(function(){
				sue.break=true;
				sue.clearUI();
			},config.general.settings.timeoutvalue*1000)
		}
		sue._lastX=e.clientX;
		sue._lastY=e.clientY;
	},
	UI:function(style){
		var domui=sue.document.querySelector("div[data-suui=uibox][data-sustyle="+style+"]");
		if(!domui){
			domui=document.createElement("div");
			domui.dataset.suui="uibox";
			domui.dataset.sustyle=style;
			domui.style.cssText+=
				"position:fixed;"+
				"z-index:"+parseInt((new Date())/1000);
			if(style=="hover"){
				domui.style.cssText+="right:-2px;bottom:0;text-align:right;"
			}
			if(style=="ui_bottom"){
				domui.style.cssText+="bottom:-2px;text-align:center;"
			}
			sue.document.appendChild(domui)
		}
	},
	ui_line:function(e){
		if(!sue.document.querySelector("div[data-suui=line]")){
			var svgdiv=this.svgdiv= document.createElement("div");
				svgdiv.dataset.suui="line";
				svgdiv.style.cssText+="position:fixed;left:0;top:0;display:block;background:transparent;border:none;"+
					"width:"+sue.window.innerWidth+"px;"+
					"height:"+sue.window.innerHeight+"px;"+
					"z-index:"+parseInt((new Date().getTime())/1000);
			var SVG = 'http://www.w3.org/2000/svg';
			var svgtag= sue.svgtag= document.createElementNS(SVG, "svg");
				svgtag.style.cssText+="width:"+sue.window.innerWidth+"px;"+"height:"+sue.window.innerHeight+"px;";
			var polyline = document.createElementNS(SVG, 'polyline');
				polyline.style.stroke=config[sue.drawType[0]].ui.line.color;
				polyline.style.strokeOpacity=config[sue.drawType[0]].ui.line.opacity;
				polyline.style.strokeWidth=config[sue.drawType[0]].ui.line.width;
				polyline.style.fill="none";
				this.polyline = polyline;
				
			svgtag.appendChild(polyline);
			svgdiv.appendChild(svgtag);
			sue.document.appendChild(svgdiv);
		}
		//console.log(sue.svgtag)
		this.startX = e.clientX;
		this.startY = e.clientY;
		if(sue.svgtag){
			var p =sue.svgtag.createSVGPoint();
			p.x = this.startX;
			p.y = this.startY;
			this.polyline.points.appendItem(p);
		}else{
			return
		}
	},
	ui_direct:function(e){
		if(!config[sue.drawType[0]].ui.direct.enable){return;}
		var uidom=sue.document.querySelector("div[data-suui=uibox][data-sustyle="+config[sue.drawType[0]].ui.direct.style+"]");
		var ui_dir=uidom.querySelector("div[data-suui=dir]");
		if(ui_dir){
			var _img=document.createElement("img");
				_img.src=chrome.extension.getURL("")+"image/"+"direct.png";
				_img.style.cssText+=
					"float:left;"+
					sue.directimg(sue._dirArray[sue._dirArray.length-1])+
					"zoom:"+Number(config[sue.drawType[0]].ui.direct.width)/32;
					//"background-color:"+config[sue.drawType[0]].ui.direct.color;
			ui_dir.appendChild(_img)
		}else{
			ui_dir=document.createElement("div");
			ui_dir.dataset.suui="dir";
			ui_dir.style.cssText+=
				"display:inline-block;text-align:center;border-radius:2px;padding:0 5px;"+
				"background-color:"+config[sue.drawType[0]].ui.direct.color+" !important;"+
				"opacity:"+config[sue.drawType[0]].ui.direct.opacity;
			ui_dir.appendChild(sue.domDir2(sue._dirArray[sue._dirArray.length-1]));
			uidom.appendChild(ui_dir);

			var _br=document.createElement("br");
				_br.style.cssText+="/*display:none;*/";
			uidom.appendChild(_br);
		}
	},
	ui_tip:function(confOBJ,e){
		if(!config[sue.drawType[0]].ui.tip.enable){return;}
		var uidom=sue.document.querySelector("div[data-suui=uibox][data-sustyle="+config[sue.drawType[0]].ui.tip.style+"]");
		if(!uidom){return}
		var _dom=uidom?uidom.querySelector("div[data-suui=tip]"):null;
		if(!_dom){
			var _dom=document.createElement("div");
				_dom.dataset.suui="tip";
				_dom.style.cssText+=
					"display:inline-block;padding: 3px 5px;border-radius: 3px;font-family: arial,sans-serif !important;"+
					"background-color:"+config[sue.drawType[0]].ui.tip.bgcolor+";"+
					"color:"+config[sue.drawType[0]].ui.tip.color+";"+
					"font-size:"+config[sue.drawType[0]].ui.tip.width+"px;"+
					"opacity:"+config[sue.drawType[0]].ui.tip.opacity+";"
			uidom.appendChild(_dom);
			var _br=document.createElement("br");
				_br.style.cssText+="/*display:none;*/";
			uidom.appendChild(_br);
		}
		if(confOBJ.tip){
			var domdir=sue.domDir();
			_dom.innerHTML=(domdir+confOBJ.tip);
			_dom.style.cssText+="display:inline-block;";
		}else{
			_dom.innerHTML="";
			_dom.style.cssText+="display:none;";
		}
	},
	ui_note:function(confOBJ,e){
		if(!config[sue.drawType[0]].ui.note.enable){return;}
		var uidom=sue.document.querySelector("div[data-suui=uibox][data-sustyle="+config[sue.drawType[0]].ui.note.style+"]");
		var _dom=uidom.querySelector("div[data-suui=note]");
		if(!_dom){
		    _dom=document.createElement("div");
			_dom.dataset.suui="note";
			_dom.style.cssText+="font-family: arial,sans-serif !important;font-style: italic;/*position:fixed;*/"+
			"color:"+config[sue.drawType[0]].ui.note.color+";"+
			"font-size:"+config[sue.drawType[0]].ui.note.width+"px;"+
			"opacity:"+config[sue.drawType[0]].ui.note.opacity+";"
			//_dom.innerText=confOBJ.note.value;
			uidom.appendChild(_dom);
			uidom.appendChild(document.createElement("br"));
		}
		if(confOBJ.note&&confOBJ.note.type&&confOBJ.note.value){
			_dom.style.cssText+="display:inline-block;";
			_dom.innerText=confOBJ.note.value;
		}else{
			_dom.style.cssText+="display:none;";
			_dom.innerText="";
			return;
		}
		return
		if(_dom&&!confOBJ.note.value){
			_dom.style.cssText+="display:none;";
			_dom.innerText="";
			return;
		}
		if(_dom){
			_dom.style.cssText+="display:inline-block;";
			_dom.innerText=confOBJ.note.value;
		}else{
		    _dom=document.createElement("div");
			_dom.dataset.suui="note";
			_dom.style.cssText+="font-family: arial,sans-serif !important;font-style: italic;position:fixed;"+
			"color:"+config[sue.drawType[0]].ui.note.color+";"+
			"font-size:"+config[sue.drawType[0]].ui.note.width+"px;"+
			"opacity:"+config[sue.drawType[0]].ui.note.opacity+";"
			_dom.innerText=confOBJ.note.value;
			uidom.appendChild(_dom);
			uidom.appendChild(document.createElement("br"));
		}
	},
	ui_allaction:function(confOBJ,e){
		if(!config[sue.drawType[0]].ui.allaction.enable){return;}
		var uidom=sue.document.querySelector("div[data-suui=uibox][data-sustyle="+config[sue.drawType[0]].ui.allaction.style+"]");
		var _dom=uidom.querySelector("div[data-suui=allaction]");
		if(!_dom){
		    _dom=document.createElement("div");
			_dom.dataset.suui="allaction";
			_dom.style.cssText+="font-family: arial,sans-serif !important;text-align:left;padding: 5px 20px;border-radius: 2px;"+
			"color:"+config[sue.drawType[0]].ui.allaction.color+";"+
			"background-color:"+config[sue.drawType[0]].ui.allaction.bgcolor+";"+
			"font-size:"+config[sue.drawType[0]].ui.allaction.width+"px;"+
			"opacity:"+config[sue.drawType[0]].ui.allaction.opacity+";"
			uidom.appendChild(_dom);
			//uidom.appendChild(document.createElement("br"));
		}else{
			_dom.innerHTML="";
		}
		if(confOBJ.allaction&&confOBJ.allaction.length>0){
			for(var i=0;i<confOBJ.allaction.length;i++){
				var _img="";
				for(var ii=0;ii<confOBJ.allaction[i].direct.length;ii++){
					_img+="<img src='"+chrome.extension.getURL("")+"image/"+"direct.png"+"' style='float:left;"+sue.directimg(confOBJ.allaction[i].direct[ii])+";zoom:"+Number(config[sue.drawType[0]].ui.allaction.width)/32+"'>"
				}
				var _acction=document.createElement("div");
					_acction.innerHTML=_img+"&nbsp;&nbsp;"+confOBJ.allaction[i].tip;
				_dom.appendChild(_acction);
			}
			_dom.style.cssText+="display:inline-block;";
		}else{
			_dom.innerHTML="";
			_dom.style.cssText+="display:none;";
		}
	},
	directimg:function(direct){
		var myDeg={L:"0deg",U:"90deg",R:"180deg",D:"270deg"};
		return "-webkit-transform:rotate(+"+myDeg[direct]+");";
	},
	domDir2:function(img){
		var domimg=document.createElement("img");
			domimg.src=chrome.extension.getURL("")+"image/"+"direct.png";
			domimg.style.cssText+=
				"float:left;"+
				sue.directimg(img)+
				"zoom:"+Number(config[sue.drawType[0]].ui.direct.width)/32;
				//";zoom:"+Number(config[sue.drawType[0]].ui.tip.width)/32+"'>"
		return domimg;
	},
	domDir:function(){
		if(config[sue.drawType[0]].ui.tip.withdir){
			var domdir="";
			for(var i=0;i<sue._dirArray.length;i++){
				domdir+="<img src='"+chrome.extension.getURL("")+"image/"+"direct.png"+"' style='float:left;"+sue.directimg(sue._dirArray[i])+";zoom:"+Number(config[sue.drawType[0]].ui.tip.width)/32+"'>"
			}
			return domdir;
			//confOBJ.tip?domtip.innerHTML=domdir+confOBJ.tip:dom.remove();			
		}else{
			return "";
		}
	},
	uiPos:function(e){
		var uibox_follow=sue.document.querySelector("div[data-suui=uibox][data-sustyle=follow]"),
			uibox_center=sue.document.querySelector("div[data-suui=uibox][data-sustyle=center]"),
			uibox_bottom=sue.document.querySelector("div[data-suui=uibox][data-sustyle=ui_bottom]");
		uibox_follow?(uibox_follow.style.cssText+="left:"+(e.clientX+10)+"px;"+"top:"+(e.clientY+30)+"px"):null;
		if(uibox_center){
			var _width=window.getComputedStyle(uibox_center).width;
				_width=_width.substr(0,_width.length-2);
				_width=(window.innerWidth-_width)/2;
			var _height=window.getComputedStyle(uibox_center).height;
				_height=_height.substr(0,_height.length-2);
				_height=(window.innerHeight-_height)/2;
			uibox_center.style.cssText+=
				"left:"+_width+"px;"+
				"top:"+_height+"px;";
		}
		if(uibox_bottom){
			var _width=window.getComputedStyle(uibox_bottom).width;
				_width=_width.substr(0,_width.length-2);
				_width=(window.innerWidth-_width)/2;
			var _height=window.getComputedStyle(uibox_bottom).height;
				_height=_height.substr(0,_height.length-2);
				_height=(window.innerHeight-_height)/2;
			uibox_bottom.style.cssText+=
				"left:"+_width+"px;"/*+
				"top:"+_height+"px;";*/
		}
	},
	clearUI:function(){
		//return
		sue.document.querySelector("div[data-suui=line]")?sue.document.querySelector("div[data-suui=line]").remove():null;
		var doms=sue.document.querySelectorAll("div[data-suui=uibox]");
		for(var i=0;i<doms.length;i++){
			if(doms[i]){doms[i].remove()}
		}
		sue.drawing=false;
	},
	stopMges:function(e){
		if(sue.break){
			sue.clearUI();
			sue.break=false;
			return;
		}
		sue.clearUI();
		if(editMode){
			editDirect=sue._dirArray;
			var getele=function(ele){
				if(ele.tagName.toLowerCase()=="smartup"&&ele.classList.contains("su_apps")){
					return ele;
				}else{
					return getele(ele.parentNode);
				}
			}
			var boxOBJ=getele(document.querySelector(".su_app_test"));
			boxOBJ.querySelector(".testbox").innerText=sue._dirArray;
		}else{
			sue.sendDir(sue._dirArray,"action",e);
		}
		e.preventDefault();
		sue._dirArray="";
		sue.drawing=false;
	},
	sendDir:function(dir,dirType,e){
		//console.log(sue.drawType)
		var returnValue;
		chrome.runtime.sendMessage({type:dirType,direct:dir,drawType:sue.drawType,selEle:sue.selEle},function(response){
  			returnValue=response;
  			sue.getedConf=returnValue;
  			switch(response.type){
  				case"tip":
  					sue.ui_tip(response,e);
  					sue.ui_note(response,e);
  					sue.ui_allaction(response,e);
  					sue.uiPos(e);
  					break;
  				case"action":
  					switch(response.typeAction){
  						case"paste":
  							//console.log("response.paste")
							sue.startEle.value+=response.paste;
  							break;
  					}
  					break;
  			}
		});
	}
}
chrome.runtime.onMessage.addListener(function(message,sender,sendResponse) {
	if(message.type=="status"){
		sendResponse({type:message.type,message:true})
	}
});
chrome.runtime.sendMessage({type:"evt_getconf"},function(response){
	if(response){
		config=response.config;
		_OS=response.os;
		sue.init();
	}
})